﻿using System.Runtime.Serialization;
using System;
using BMS.ServiceContracts;
using System.Collections.Generic;
using BMS.DataContracts;
using BMS.Utils;
using InfoWorld.HL7.ITS;

namespace BMS.ServicesWrapper.Proxy
{
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public interface IBedManagerQueryChannel : IBedManagerQuery, System.ServiceModel.IClientChannel
    {
    }

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public partial class BedManagerQueryClient : System.ServiceModel.ClientBase<IBedManagerQuery>, IBedManagerQuery, System.IDisposable
    {
        #region ProxyTool Generated Code

        private BedManagerQueryClient _instance;
        private string _endpointConfigurationName;
        private string _remoteAddress;
        private System.ServiceModel.EndpointAddress _endpointAddress;
        private System.ServiceModel.Channels.Binding _binding;


        private void InitProxyInstance()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        if (_instance.State != System.ServiceModel.CommunicationState.Faulted)
                            _instance.Close();
                        else
                            _instance.Abort();
                }
                catch { }

                if (_binding != null)
                    _instance = new BedManagerQueryClient(_binding, _endpointAddress);
                else if (_endpointAddress != null)
                    _instance = new BedManagerQueryClient(_endpointConfigurationName, _endpointAddress);
                else if (_remoteAddress != null)
                    _instance = new BedManagerQueryClient(_endpointConfigurationName, _remoteAddress);
                else if (_endpointConfigurationName != null)
                    _instance = new BedManagerQueryClient(_endpointConfigurationName);
                else
                    _instance = new BedManagerQueryClient();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        void System.IDisposable.Dispose()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.Close();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Close()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<IBedManagerQuery>)_instance).Close();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<IBedManagerQuery>)this).Close();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Abort()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<IBedManagerQuery>)_instance).Abort();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<IBedManagerQuery>)this).Abort();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion


        public BedManagerQueryClient()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BedManagerQueryClient(string endpointConfigurationName) : base(endpointConfigurationName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BedManagerQueryClient(string endpointConfigurationName, string remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _remoteAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BedManagerQueryClient(string endpointConfigurationName, System.ServiceModel.EndpointAddress remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BedManagerQueryClient(System.ServiceModel.Channels.Binding binding, System.ServiceModel.EndpointAddress remoteAddress) : base(binding, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _binding = binding;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public IList<AdmissionInfo> FilterAdmissions(Guid facilityUid, DateTime admissionCreationTime, bool isOnlyCurrentWaitingAdmission, bool isOnlyInHouseWaitingAdmission, bool isMentalHealth, bool isEmergencyManagement, bool isFee)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.FilterAdmissions(facilityUid, admissionCreationTime, isOnlyCurrentWaitingAdmission, isOnlyInHouseWaitingAdmission, isMentalHealth, isEmergencyManagement, isFee);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.FilterAdmissions(facilityUid, admissionCreationTime, isOnlyCurrentWaitingAdmission, isOnlyInHouseWaitingAdmission, isMentalHealth, isEmergencyManagement, isFee);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public IList<TransferInfo> FilterTransfers(Guid? facilityUid, string facilityVISN)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.FilterTransfers(facilityUid, facilityVISN);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.FilterTransfers(facilityUid, facilityVISN);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public IList<BedOccupancyInfo> FilterBedOccupancy(string wardList, II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.FilterBedOccupancy(wardList, facilityId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.FilterBedOccupancy(wardList, facilityId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<BedDNDAndOOS> FilterBedsDNDAndOOS(string wardList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.FilterBedsDNDAndOOS(wardList);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.FilterBedsDNDAndOOS(wardList);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public IList<BedCleanInfo> FilterBedClean(string wardList, DateTime startDate, DateTime endDate)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.FilterBedClean(wardList, startDate, endDate);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.FilterBedClean(wardList, startDate, endDate);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public IList<PatientWaitingStandardView> FilterNationalPatientWaitingStandardView(bool isDisplayOnlyNationalPatients, string facilityRegion, string facilityVISN, string specialtyCode, string specialtyCodeSystem, DateTime transferDateTime, bool isCurrentWaitingList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.FilterNationalPatientWaitingStandardView(isDisplayOnlyNationalPatients, facilityRegion, facilityVISN, specialtyCode, specialtyCodeSystem, transferDateTime, isCurrentWaitingList);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.FilterNationalPatientWaitingStandardView(isDisplayOnlyNationalPatients, facilityRegion, facilityVISN, specialtyCode, specialtyCodeSystem, transferDateTime, isCurrentWaitingList);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public IList<PatientWaitingDateView> FilterNationalPatientWaitingDateView(bool isDisplayOnlyNationalPatients, string facilityRegion, string facilityVISN, string specialtyCode, string specialtyCodeSystem, DateTime transferDateTime, bool isCurrentWaitingList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.FilterNationalPatientWaitingDateView(isDisplayOnlyNationalPatients, facilityRegion, facilityVISN, specialtyCode, specialtyCodeSystem, transferDateTime, isCurrentWaitingList);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.FilterNationalPatientWaitingDateView(isDisplayOnlyNationalPatients, facilityRegion, facilityVISN, specialtyCode, specialtyCodeSystem, transferDateTime, isCurrentWaitingList);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public IList<BMS.DataContracts.NewEvent> GetNewEvents(string wardUidList, Guid facilityidentifier, int timeZoneMinutesOffset)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetNewEvents(wardUidList, facilityidentifier, timeZoneMinutesOffset);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetNewEvents(wardUidList, facilityidentifier, timeZoneMinutesOffset);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public IList<JobLogInfo> FilterLogData(IList<string> vistaIds, IList<DataRetrievalMethod> retrievalMethods, IList<VistaDataType> dataTypes, DateTime startDate, DateTime? endDate, IList<JobStatus> status, PagingContext pagingContext, bool is_view_only_last_information)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.FilterLogData(vistaIds, retrievalMethods, dataTypes, startDate, endDate, status, pagingContext, is_view_only_last_information);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.FilterLogData(vistaIds, retrievalMethods, dataTypes, startDate, endDate, status, pagingContext, is_view_only_last_information);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public Act GetLastAct(II patientId, ActType actType, II vistaSiteId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetLastAct(patientId, actType, vistaSiteId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetLastAct(patientId, actType, vistaSiteId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public IList<BedOccupancyCount> GetPercentageOfOccupancy(string vistaSitesList, string wardsList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetPercentageOfOccupancy(vistaSitesList, wardsList);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetPercentageOfOccupancy(vistaSitesList, wardsList);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public PatientWaitingCount GetPatientsWaitingCount(Guid facilityUid, Guid vistaSiteUid, string vistaDivisionCode, int timeZoneOffset)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetPatientsWaitingCount(facilityUid, vistaSiteUid, vistaDivisionCode, timeZoneOffset);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetPatientsWaitingCount(facilityUid, vistaSiteUid, vistaDivisionCode, timeZoneOffset);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<IconInfo> FilterIconInfo(string listType, string iconFlagIds, II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.FilterIconInfo(listType, iconFlagIds, facilityId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.FilterIconInfo(listType, iconFlagIds, facilityId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<IconAssociationInfo> FilterBedPatientIconAssociation(Guid bedUid, Guid? patientUid, Guid facilityUid)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.FilterBedPatientIconAssociation(bedUid, patientUid, facilityUid);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.FilterBedPatientIconAssociation(bedUid, patientUid, facilityUid);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public IList<OccupiedBedInfo> GetOccupiedBeds(II vistaSiteId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetOccupiedBeds(vistaSiteId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetOccupiedBeds(vistaSiteId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<IconAssociation> FilterBedIconAssociation(string bedUids, Guid facilityUid)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.FilterBedIconAssociation(bedUids, facilityUid);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.FilterBedIconAssociation(bedUids, facilityUid);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public Dictionary<Guid, DataContracts.PatientIcon> GetPatientIcons(string group, string subGroup, string patientUidList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetPatientIcons(group, subGroup, patientUidList);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetPatientIcons(group, subGroup, patientUidList);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<WaitingListReport> FilterWaitingListReport(Guid facilityUid, string filterBy)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.FilterWaitingListReport(facilityUid, filterBy);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.FilterWaitingListReport(facilityUid, filterBy);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public IList<EvacuationPatient> GetEvacuationPatients(string wardList, II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetEvacuationPatients(wardList, facilityId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetEvacuationPatients(wardList, facilityId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<BedCleanInfo> FilterBedCleanAssignedAndPending(string wardList, string acceptedBy)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.FilterBedCleanAssignedAndPending(wardList, acceptedBy);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.FilterBedCleanAssignedAndPending(wardList, acceptedBy);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<EmsStaff> FilterEmsStaff(II facilityId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.FilterEmsStaff(facilityId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.FilterEmsStaff(facilityId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<BedStaffHistory> GetBedStaffHistory(II bedId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetBedStaffHistory(bedId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetBedStaffHistory(bedId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
		
        public IList<Order> GetCancelableOrders(II vistaSiteId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetCancelableOrders(vistaSiteId);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetCancelableOrders(vistaSiteId);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public IList<VistaIntegrationLog> GetAlreadyExistsVistaIntegrationLogs(IEnumerable<VistaIntegrationLog> data, string vista)
        {
            try
            {
                return _instance.Channel.GetAlreadyExistsVistaIntegrationLogs(data, vista);
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    return _instance.Channel.GetAlreadyExistsVistaIntegrationLogs(data, vista);
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
            }
        }

        public IList<BedUnavailableInfo> FilterBedUnavailableInfo(II vistaId)
        {
            try
            {
                return _instance.Channel.FilterBedUnavailableInfo(vistaId);
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    return _instance.Channel.FilterBedUnavailableInfo(vistaId);
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
            }
        }

        public IList<II> FilterUpdatingPatients(II vistaId)
        {
            try
            {
                return _instance.Channel.FilterUpdatingPatients(vistaId);
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    return _instance.Channel.FilterUpdatingPatients(vistaId);
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
            }
        }

        public List<DataContracts.MovementIen> GetMovementIens(DateTime startDate, DateTime endDate, II vistaId)
        {
            try
            {
                return _instance.Channel.GetMovementIens(startDate, endDate, vistaId);
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    return _instance.Channel.GetMovementIens(startDate, endDate, vistaId);
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
            }
        }

        public List<MovementWithoutBed> FilterMovementsWithoutBed(DateTime startDate, DateTime endDate, II vistaId)
        {
            try
            {
                return _instance.Channel.FilterMovementsWithoutBed(startDate, endDate, vistaId);
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    return _instance.Channel.FilterMovementsWithoutBed(startDate, endDate, vistaId);
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
            }
        }

        public List<string> GetMissingAdmissions(string admissionIenList, II vistaId)
        {
            try
            {
                return _instance.Channel.GetMissingAdmissions(admissionIenList, vistaId);
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    return _instance.Channel.GetMissingAdmissions(admissionIenList, vistaId);
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
            }
        }

        public DateTime? FilterBPLastRun(string vistaId, IList<DataRetrievalMethod> retrievalMethods, IList<VistaDataType> dataTypes, IList<JobStatus> status)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.FilterBPLastRun(vistaId, retrievalMethods, dataTypes, status);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.FilterBPLastRun(vistaId, retrievalMethods, dataTypes, status);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void GetHomePageBMSData(Guid facilityUid, string vistaId, DateTime admissionCreationTime, bool isOnlyCurrentWaitingAdmission, bool isOnlyInHouseWaitingAdmission, bool isMentalHealth, bool isEmergencyManagement, bool isFee,
            string fullUserName, out List<BedOccupancyCount> bedOccupancylist, out List<AdmissionInfo> facilityWaitingList)
        {
            try
            {
                _instance.Channel.GetHomePageBMSData(facilityUid, vistaId, admissionCreationTime, isOnlyCurrentWaitingAdmission, isOnlyInHouseWaitingAdmission, isMentalHealth, isEmergencyManagement, isFee, fullUserName, out bedOccupancylist, out facilityWaitingList);
            }
            catch (System.Exception e)
            {
                if (!ProxyManager.CheckThrownException(e))
                    throw;
                else
                {
                    InitProxyInstance();
                    _instance.Channel.GetHomePageBMSData(facilityUid, vistaId, admissionCreationTime, isOnlyCurrentWaitingAdmission, isOnlyInHouseWaitingAdmission, isMentalHealth, isEmergencyManagement, isFee, fullUserName, out bedOccupancylist, out facilityWaitingList);
                }
            }
            finally
            {
                ProxyManager.ReturnProxy<BedManagerQueryClient>(_instance, _endpointConfigurationName);
            }
        }
    }
}
